#!/usr/bin/env python3
# coding: utf-8

import socket
import configparser
import os
import re
import time

# charger la conf
config = configparser.ConfigParser()
config.read("config.ini")

cfg = {
    "DATA": config["GENERAL"]["DATA"],
    "FIC_SRC": config["GENERAL"]["FIC_SRC"],
    "DELAY": int(config["GENERAL"]["DELAY"]),
    "SIZE_LIMIT": int(config["GENERAL"]["SIZE_LIMIT"]),
    "SFTP_SRV": config["SFTP"]["SFTP_SRV"],
    "SFTP_PORT": int(config["SFTP"]["SFTP_PORT"]),
    "SFTP_USER": config["USER"]["TAG"],
    "SFTP_PWD": config["USER"]["PWD"],
    "SFTP_DIR": config["SFTP"]["SFTP_DIR"],
    "NMEA_SRV": config["NMEA"]["NMEA_SRV"],
    "NMEA_PORT": int(config["NMEA"]["NMEA_PORT"]),
}

HOST = cfg["NMEA_SRV"]
PORT = cfg["NMEA_PORT"]
OUTPUT_FILE = os.path.join(cfg["DATA"], cfg["FIC_SRC"])

# Liste des préfixes de trames à conserver
TRAMES_REGEX = re.compile(
    r"^\$(..)(RMC|GNS|GGA|GLL|MWV|MDA|MBP|MTW|MTA|HDG|VHW|DPT|DBT|RPM),"
)

FLUSH_INTERVAL = 10  # Écrire toutes les x secondes
buffer = []  # Liste tampon pour stocker les lignes

last_flush_time = time.time()  # Initialiser le temps de référence

with socket.socket(socket.AF_INET, socket.SOCK_DGRAM) as s:
    s.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
    s.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEPORT, 1)
    s.bind((HOST, PORT))
    print(f"📡 Waiting NMEA frames UDP port {PORT}...")

    f = open(OUTPUT_FILE, "a")  # Ouverture initiale en mode ajout

    try:
        while True:

            # Lire les données en UDP
            data, addr = s.recvfrom(1024)
            lines = data.decode("ascii", errors="ignore").strip().split("\r\n")  # Séparation des trames

            for line in lines:
                if TRAMES_REGEX.match(line):
                    print("✅ :", line)
                    buffer.append(line.rstrip("\r\n") + "\n")
                else:
                    print("❌ :", line)

            if time.time() - last_flush_time >= FLUSH_INTERVAL:
                with open(OUTPUT_FILE, "a") as f:
                    f.writelines(buffer)  # Écriture en bloc
                    f.flush()

                buffer.clear()  # Vider la liste
                last_flush_time = time.time()  # Réinitialiser le timer

    except KeyboardInterrupt:
        print("\n🛑 : Stopped")
    finally:
        f.close()  # S'assurer que le fichier est bien fermé en sortie
